/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.SoundsInit;
import com.mcwwindows.kikoz.objects.WindowBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Blinds
extends WindowBase {
    private static final EnumProperty<GaragePart> PART = EnumProperty.m_61587_((String)"part", GaragePart.class);
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty RAISE = BlockStateProperties.f_61366_;
    String infoname;
    boolean hasTextInfo = true;
    protected static final VoxelShape WEST = Shapes.m_83124_((VoxelShape)Blinds.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape SOUTH = Shapes.m_83124_((VoxelShape)Blinds.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape EAST = Shapes.m_83124_((VoxelShape)Blinds.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NORTH = Shapes.m_83124_((VoxelShape)Blinds.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return null;
    }

    public Blinds() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(0.5f, 0.5f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RAISE, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)GaragePart.BOTTOM)));
    }

    @Override
    protected BlockState WindowState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean below;
        boolean above = level.m_8055_(pos.m_7494_()).m_60734_() == this;
        boolean bl = below = level.m_8055_(pos.m_7495_()).m_60734_() == this;
        if (above && below) {
            return (BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.BOTTOM));
        }
        if (!above && below) {
            return (BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.TOP));
        }
        if (above && !below) {
            return (BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.BOTTOM));
        }
        return (BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.TOP));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.WindowState(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_()).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, FACING, WATERLOGGED, OPEN, RAISE});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        if (item != this.m_5456_()) {
            Boolean raised = (Boolean)state.m_61143_((Property)RAISE);
            if (player.m_6047_()) {
                this.raiseBlinds(worldIn, pos, (Boolean)state.m_61143_((Property)RAISE) == false, (Direction)state.m_61143_((Property)FACING), 1000);
                worldIn.m_5594_(null, pos, (SoundEvent)SoundsInit.BLINDS_CLOSE.get(), SoundSource.BLOCKS, 0.5f, worldIn.f_46441_.nextFloat() * 0.1f + 0.8f);
                state = (BlockState)state.m_61122_((Property)RAISE);
                worldIn.m_7731_(pos, state, 10);
                return InteractionResult.SUCCESS;
            }
            if (!raised.booleanValue()) {
                this.toggleBlinds(worldIn, pos, (Boolean)state.m_61143_((Property)OPEN) == false, (Direction)state.m_61143_((Property)FACING), 1000);
                worldIn.m_5594_(null, pos, (SoundEvent)SoundsInit.BLINDS_CLOSE.get(), SoundSource.BLOCKS, 0.5f, worldIn.f_46441_.nextFloat() * 0.1f + 0.8f);
                state = (BlockState)state.m_61122_((Property)OPEN);
                worldIn.m_7731_(pos, state, 10);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, Level worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_183324_().m_183582_(currentPos, (Object)Fluids.f_76193_);
        }
        return super.updatePostPlacement(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76145_() : super.m_5888_(state);
    }

    private void raiseBlinds(Level world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == this) {
            boolean open = (Boolean)state.m_61143_((Property)RAISE);
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            if (open != targetOpen && direction.equals((Object)targetDirection)) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)RAISE, (Comparable)Boolean.valueOf(targetOpen)));
                if (direction.m_122434_() == Direction.Axis.X) {
                    this.raiseBlinds(world, pos.m_142383_(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_142390_(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_6625_(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_6625_(2), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_6630_(1), targetOpen, targetDirection, depth - 2);
                }
                if (direction.m_122434_() == Direction.Axis.Z) {
                    this.raiseBlinds(world, pos.m_142385_(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_142386_(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_6625_(1), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_6625_(2), targetOpen, targetDirection, depth - 2);
                    this.raiseBlinds(world, pos.m_6630_(1), targetOpen, targetDirection, depth - 2);
                }
            }
        }
    }

    private void toggleBlinds(Level world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == this) {
            boolean open = (Boolean)state.m_61143_((Property)OPEN);
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            if (open != targetOpen && direction.equals((Object)targetDirection)) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(targetOpen)));
                if (direction.m_122434_() == Direction.Axis.X) {
                    this.toggleBlinds(world, pos.m_142383_(1), targetOpen, targetDirection, depth - 2);
                    this.toggleBlinds(world, pos.m_142390_(1), targetOpen, targetDirection, depth - 2);
                    this.toggleBlinds(world, pos.m_6625_(1), targetOpen, targetDirection, depth - 2);
                    this.toggleBlinds(world, pos.m_6625_(2), targetOpen, targetDirection, depth - 2);
                    this.toggleBlinds(world, pos.m_6630_(1), targetOpen, targetDirection, depth - 2);
                }
                if (direction.m_122434_() == Direction.Axis.Z) {
                    this.toggleBlinds(world, pos.m_142385_(1), targetOpen, targetDirection, depth - 2);
                    this.toggleBlinds(world, pos.m_142386_(1), targetOpen, targetDirection, depth - 2);
                    this.toggleBlinds(world, pos.m_6625_(1), targetOpen, targetDirection, depth - 2);
                    this.toggleBlinds(world, pos.m_6625_(2), targetOpen, targetDirection, depth - 2);
                    this.toggleBlinds(world, pos.m_6630_(1), targetOpen, targetDirection, depth - 2);
                }
            }
        }
    }

    public static enum GaragePart implements StringRepresentable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private GaragePart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

